
#%%
import numpy as np
import matplotlib.pyplot as plt
t = 20*np.arange(18) # on génère une base de temps de 18 points espacés de 20 ms. 
v=np.array([0,14,23,29,34,37,39,40,41,42,43,43,43,43,43,43,43,43])
# on rentre les valeurs de la vitesse en fonction du temps
#%%

# courbe
plt.figure() #tracé classique
plt.plot(t,v,'bo', label='vitesse')
plt.legend()
plt.grid()
plt.xlabel("temps")
plt.ylabel("vitesse")
plt.title("Vitesse de la bille en fonction du temps")
plt.show()
#%%
# on définit l'accélération, avec le même protocole que dans les fiches précédentes. 
al=[] # on définit une liste vide
m=np.arange(len(t)-2)
for i in m :
    a=(v[i+2]-v[i])/(t[i+2]-t[i])
    al.append(a)
v0=v[1:-1] #on enlève le premier et le dernier terme. 
# regression lineaire
mod=np.polyfit(v0,al,1) # on modélise al en fontion v0 par un fonction affine. 
model=mod[0]*v0+mod[1] #on définit la fonction correspondant à ce modèle
print(mod) # on fait afficher les paramètres de la modélisation pour vérification des valeurs numériques

#%%
# Courbe
plt.figure()
plt.plot(v0,al,'ro',label='points expérimentaux') #on fait tracer la liste des points exéprimentaux 
plt.plot(v0,model,'b-',label='modèle affine') #et le modèle sur le même graphe. 
plt.legend()
plt.grid()
plt.xlabel("vitesse")
plt.ylabel("accélération")
plt.title("Modèle de la force subie par la bille")
plt.show()
